﻿var capiSyncHistory = {
    context: $(".v-capiSyncHistory"),
    datatable: null,
    projectId: null,
    initializeDataTable: function () {
        this.datatable = $(".h-capiSyncHistory-table", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getProjectAction("GetProjectCAPISyncHistories", "Diagnostics"),
            columns: [
                { "Title": resources.StartDate, "Data": "StartDate", "Type": "date" },
                { "Title": resources.ProjectName, "Data": "ProjectName" },
                { "Title": resources.Interviewer, "Data": "Interviewer" },
                { "Title": resources.Workstation, "Data": "Workstation" },
                { "Title": resources.CaseID, "Data": "CaseID" },
                { "Title": resources.CaseResult, "Data": "CaseResult" },
                { "Title": resources.Completed, "Data": "Completed" },
                { "Title": resources.Status, "Data": "Status", "Type": "enum", "EnumType": "CAPIStatus" },
                { "Title": resources.Comments, "Data": "Comments" },
                { "Title": resources.Action, "Data": "Action", "Type": "enum", "EnumType": "CAPIAction" }
            ],
            contextMenuItems: [
                { "Action": "viewDetail", "Label": resources.ViewDetail }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "viewDetail":
                        modalDialog.showWindow(a4.getAction("GetSynchLogsDetail", "Diagnostics", "Settings", { syncLogID: row.LogId }), 450, 700);
                        break;
                }
            },
            stateKey: "CAPISyncHistory",
            localizableTexts: { "All": resources.AllHistories, "Search": resources.SearchHistories },
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            }
        });
    },
    bindEvents: function () {
        capiSyncHistory.context.on("click", ".h-clear", function () {
            modalDialog.showConfirmDialog(confirmDeleteSynchHistoryResources, function () {
                a4.callServerMethod(a4.getProjectAction("DeleteCAPISyncHistories", "Diagnostics"), {},
                    function () {
                        a4.showSuccessMessage(resources.ClearHistoryCompleted);
                        capiSyncHistory.refreshContent();
                    },
                    function (error) {
                        a4.onAjaxPageMethodError(error);
                    }
                );
            }, 200, 625);
        });

        capiSyncHistory.context.on("click", ".h-exportExcel", function () {
            a4.showBusyBox();
            a4.callServerMethod(a4.getProjectAction("ExportSynchHistories", "Diagnostics"), {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getProjectAction("GetSynchHistoriesFile", "Diagnostics", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });

    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (capiSyncHistory.context.length > 0) {
        capiSyncHistory.initializeDataTable();
        capiSyncHistory.bindEvents();
    }
});